import pymel.all as pm
from pymel.internal.plogging import pymelLogger

def parentShapes():
    #get the selection to act upon
    myObjects = pm.ls(sl=1)
    if not myObjects:
        pymelLogger.error('No objects selected.')
        return
    myTransform = myObjects.pop()
    if not pm.nodeType(myTransform) == 'transform':
        pymelLogger.error('Last selection must be a transform node.')
        return
    #add all shapes to the given transform node
    shapesFound=0;
    for myObject in myObjects:
        #get a list of shape nodes associated with this object
        #otherwise ignore it
        myType = pm.nodeType(myObject)
        if myType == 'nurbsCurve': #use a nurbs curve directly
            oldTransform = myObject.getParent()
            if oldTransform == myTransform: continue
            myShapes = [myObject]
            print oldTransform
            if not pm.nodeType(oldTransform) == 'transform':
                continue
        elif myType == 'transform': #get all shapes belonging to this transform
            oldTransform = myObject
            if oldTransform == myTransform: continue
            myShapes = myObject.getShapes()
            #remove non nurbs curves from the list
            for myShape in myShapes:
                if not pm.nodeType(myShape) == 'nurbsCurve':
                    myShapes.remove(myShape)
        else: continue
        
        if not myShapes: continue
        
        #to maintain world position of the current node's shapes
        #parent the old transform node to the new one & freeze transforms
        pm.parent(oldTransform, myTransform)
        pm.makeIdentity(oldTransform, apply=1, t=1, r=1, s=1)
        
        #reparent the shape nodes
        for myShape in myShapes:
            shapesFound+=1
            pm.parent(myShape, myTransform, shape=1, add=1)
        
        #delete the old transform node
        pm.delete(oldTransform)
    
    #if no shapes were found, warn the user
    if shapesFound == 0:
        pymelLogger.warning('No nurbs curves were found in the selection.')
    else: pymelLogger.debug('Reparented %s shapes'%shapesFound)
    
    #return the selection to the transform node
    pm.select(myTransform,r=1)

def createNullGroup():
    groupSuffix='RotGrp' #the suffix name to use for null groups
    myObjects = pm.ls(sl=1) #get the selection to act on
    for myObject in myObjects: #iterate through selection, give each its own null group
        #get the parent for later
        myParents = pm.listRelatives(myObject, p=1, f=1)
        if myParents: myParent = myParents[0]
        else: myParent = 0
        #create null group
        myGroup = pm.group(myObject, n=myObject+groupSuffix, w=1)
        if myParent: pm.parent(myGroup, myParent)
        #transfer object's data to null group
        pm.move([myGroup.rotatePivot, myGroup.scalePivot], pm.xform(myObject, q=1, ws=1, rp=1), rpr=1) #align pivots
        pm.rotate(myGroup, pm.xform(myObject, q=1, ws=1, ro=1)) #align group rotation
        pm.rotate(myObject, [0, 0, 0]) #straighten object rotation
        pm.makeIdentity(myObject, apply=1, t=1, n=0) #remove translations
        pm.select(myObject) #return selection to object