import pymel.all as pm
from pymel.internal.plogging import pymelLogger

#simple mirror set driven keys command
#mirrors the selected nodes' incoming unitless animCurves
def mirrorDriven(side='left'):
    currSelection = pm.ls(sl=1) #grab the current selection
    
    if side == 'left': newSide='right'
    elif side == 'Left': newSide='Right'
    elif side == 'right': newSide='left'
    elif side == 'Right': newSide='Left'
    else: pymelLogger.error('Unsure how to mirror: no "left" or "right" found in selected')
    
    for myObject in currSelection:
        for myDrivenCurve in pm.listConnections(myObject, s=1,d=0,type=('animCurveUA','animCurveUL','animCurveUT','animCurveUU')):
            #duplicate the curve, return value of duplicate is bugged for animCurve nodes
            pm.select(myDrivenCurve)
            pm.duplicate(n=str(myDrivenCurve).replace(side,newSide),rr=1)
            newDrivenCurve = pm.ls(sl=1)[0]
            #make the mirrored connections
            for myConnection in pm.listConnections(myDrivenCurve,s=1,d=0,p=1,scn=1):
                pm.connectAttr(str(myConnection).replace(side,newSide), '%s.input'%newDrivenCurve)
            for myConnection in pm.listConnections(myDrivenCurve,s=0,d=1,p=1,scn=1):
                pm.connectAttr('%s.output'%newDrivenCurve,str(myConnection).replace(side,newSide))