import pymel.all as pm
from pymel.internal.plogging import pymelLogger

#renames the currently selected hierarchy by replacing
def recursiveReplace(old='', o='', new='', n='', sameType=0, recursive=1):
    #get the names for replacing
    if not old:
        if o:
            old = o
        else:
            result1 = pm.promptDialog(title='Heirarchy Renamer', message='Name to be replaced:', button=['OK', 'Cancel'], defaultButton='OK', cancelButton='Cancel', dismissString='Cancel')
            if result1 == "OK":
                old = pm.promptDialog(query=True, text=True)
            else: return
    if not new:
        if n:
            new = n
        else:
            result2 = pm.promptDialog(title='Heirarchy Renamer', message='New name to use:', button=['OK', 'Cancel'], defaultButton='OK', cancelButton='Cancel', dismissString='Cancel')
            if result2 == "OK":
                new = pm.promptDialog(query=True, text=True)
            else: return
    
    #get selection to act on
    currSelection = pm.ls(sl=1)
    pymelLogger.debug('Starting selection: %s'%currSelection)
    if not currSelection: return
    
    #cycle through the selection
    for headItem in currSelection:
        headItem = pm.PyNode(headItem)
        #grab all the underlings too?
        if recursive:
            pm.select(headItem, hi=1, r=1)
            renameSelection = pm.ls(sl=1)
        else: renameSelection = headItem
        pymelLogger.debug('Renaming %s and children: %s'%(headItem, renameSelection))
        #process all those underlings
        for item in renameSelection:
            typeCheck = item.nodeType()==headItem.nodeType()
            if sameType and (not typeCheck): #check type
                pymelLogger.debug('%s = %s ? %s'%(item.nodeType(),headItem.nodeType,typeCheck))
                continue
            pm.rename(item, item.replace(old, new)) #rename!
    pm.select(currSelection) #return to proper selection
    pymelLogger.info('Successfully renamed.')

#renames the currently selected hierarchy by adding a prefix or suffix
def recursiveAdd(addName='', prefix=1, sameType=0, recursive=1):
    #get selection to act on
    currSelection = pm.ls(sl=1)
    pymelLogger.debug('Starting selection: %s'%currSelection)
    if not currSelection:
        pymelLogger.error('Nothing selected.')
        return
    
    #get the names for adding
    if prefix: myType='Prefix'
    else: myType='Suffix'
    if not addName:
        result1 = pm.promptDialog(title='Add '+myType, message=myType+' to be added:', button=['OK', 'Cancel'], defaultButton='OK', cancelButton='Cancel', dismissString='Cancel')
        if result1 == "OK":
            addName = pm.promptDialog(query=True, text=True)
        else: return
    
    #cycle through the selection
    for headItem in currSelection:
        headItem = pm.PyNode(headItem)
        #grab all the underlings too?
        if recursive:
            pm.select(headItem, hi=1, r=1)
            renameSelection = pm.ls(sl=1)
        else: renameSelection = headItem
        pymelLogger.debug('Renaming %s and children: %s'%(headItem, renameSelection))
        #process all those underlings
        for item in renameSelection:
            typeCheck = item.nodeType()==headItem.nodeType()
            if sameType and (not typeCheck): #check type
                pymelLogger.debug('%s = %s ? %s'%(item.nodeType(),headItem.nodeType,typeCheck))
                continue
            if prefix: newName = '%s%s'%(addName,item)
            else: newName = '%s%s'%(item,addName)
            pm.rename(item, newName) #rename!
    pm.select(currSelection) #return to proper selection
    pymelLogger.info('Successfully renamed.')
