import pymel.all as pm
from pymel.internal.plogging import pymelLogger

#snap all objects to the last object's pivot point
def objectToPivot(withOrient=1):
    myObjects = pm.ls(sl=1) #get the selection to act upon
    if not myObjects:
        pymelLogger.error('No objects selected.')
        return
    moveSourceObj = myObjects.pop()
    if not myObjects:
        pymelLogger.error('Must select at least 2 objects.')
        return
    
    myRotPivot = pm.xform(moveSourceObj, q=1, ws=1, rp=1) #get pivot of source object
    for myObject in myObjects: #iterate through target objects
        pm.move(myObject, myRotPivot, rpr=1) #move pivots of targets
        if withOrient: #orient the object
            tempConstraint = pm.orientConstraint(moveSourceObj, myObject, mo=0)
            pm.delete(tempConstraint)
    
    pm.select(myObjects) #return selection to moved objects

#snap all objects' pivot points to the last object's pivot point
def pivotToPivot():
    myObjects = pm.ls(sl=1) #get the selection to act upon
    if not myObjects:
        pymelLogger.error('No objects selected.')
        return
    moveSourceObj = myObjects.pop()
    if not myObjects:
        pymelLogger.error('Must select at least 2 objects.')
        return
    
    myRotPivot = pm.xform(moveSourceObj, q=1, ws=1, rp=1) #get pivot of source object
    for myObject in myObjects: #iterate through target objects
        #move pivot of target object
        pm.move(myObject.rotatePivot, myRotPivot, rpr=1)
        pm.move(myObject.scalePivot, myRotPivot, rpr=1)
    
    #return selection to target objects
    pm.select(myObjects)