import pymel.all as pm
from pymel.internal.plogging import pymelLogger

#free ends: the ends of the pistons are anchored with ball joints
#else: the ends of the pistons with rotationally remain fixed to their anchors
def createPiston(pistonName='',freeEnds=0):
    currSelection = pm.ls(sl=1) #get the selection to act on
    if not currSelection:
        pymelLogger.error('Nothing is selected.')
        return
    if len(currSelection) < 4:
        print 'Please select either 4 or 6 objects.'
        print 'For each end of the pivot select: first its parent, second either the location or joint of the piston itself, and third (optionally) the geometry group that end of the piston will drive.'
        pymelLogger.error('Too few objects selected.  See script editor for details.')
        return
    if len(currSelection) == 6:
        startParent = currSelection[0]
        endParent = currSelection[3]
        startLocation = currSelection[1]
        endLocation = currSelection[4]
        startGeometry = currSelection[2]
        endGeometry = currSelection[5]  
    elif len(currSelection) > 4:
        print 'Please select either 4 or 6 objects.'
        print 'For each end of the pivot select: first its parent, second either the location or joint of the piston itself, and third (optionally) the geometry group that end of the piston will drive.'
        pymelLogger.error('Too many objects selected.  See script editor for details.')
        return
    else: #selection must be 4
        startParent = currSelection[0]
        endParent = currSelection[2]
        startLocation = currSelection[1]
        endLocation = currSelection[3]
        startGeometry=''
        endGeometry=''
    
    #get a name for this piston
    if not pistonName:
        result1 = pm.promptDialog(title='Piston Name', message='Enter the name of this piston:', button=['OK', 'Cancel'], defaultButton='OK', cancelButton='Cancel', dismissString='Cancel')
        if result1 == "OK":
            pistonName = pm.promptDialog(query=True, text=True)
        else: return
    if not pistonName: pistonName = 'piston' #default it to "piston" if all else fails
    
    #either get or create the base joint
    if pm.nodeType(startLocation) == 'joint':
        baseJoint = startLocation #we have one, so get it
    else: #need one, so make it
        pm.select(startParent,r=1)
        startPivot = pm.xform(startLocation, q=1, ws=1, rp=1)
        baseJoint = pm.joint(p=startPivot,a=1,n=pistonName+'Base')
        tempConstraint = pm.orientConstraint(startLocation, baseJoint, mo=0)
        pm.delete(tempConstraint)
    
    #create the start joint
    pm.select(baseJoint, r=1)
    startJoint = pm.joint(n=pistonName+'Start')
    
    #either get or create the end joint
    #if not free ends, create anchor on this end too
    #else use the anchor from the other side
    if pm.nodeType(endLocation) == 'joint':
        if freeEnds: endJoint = endLocation
        else: endBase = endLocation
    else:
        pm.select(startJoint,r=1)
        endPivot = pm.xform(endLocation, q=1, ws=1, rp=1)
        if freeEnds:
            endJoint = pm.joint(p=endPivot,a=1,n=pistonName+'End')
            pm.parent(endJoint, endParent)
        else:
            endBase = pm.joint(p=endPivot,a=1,n=pistonName+'EndBase')
            pm.parent(endBase, endParent)
    
    if not freeEnds:
        #build usable joint on the anchor we just made
        pm.select(endBase, r=1)
        endJoint = pm.joint(n=pistonName+'End')
        #aim constraint that uses extra anchor
        pm.aimConstraint(startJoint,endJoint,mo=0,aim=(-1,0,0),wut='objectrotation',wuo=endBase)
    else: #aim constraint that uses original anchor
        pm.aimConstraint(startJoint,endJoint,mo=0,aim=(-1,0,0),wut='objectrotation',wuo=baseJoint)
    
    #aim constraint that always uses first anchor
    pm.aimConstraint(endJoint,startJoint,mo=0,wut='objectrotation',wuo=baseJoint)
    
    #bind geometry if we have it
    if startGeometry: pm.parentConstraint(startJoint, startGeometry, mo=1)
    if endGeometry: pm.parentConstraint(endJoint, endGeometry, mo=1)