import pymel.all as pm
from pymel.internal.plogging import pymelLogger

def lockNodes(lockMe=1):
    mySelection = pm.ls(sl=1)
    for item in mySelection:
        try:
            pm.lockNode(item, l=lockMe)
        except:
            pymelLogger.debug('Failed to lock/unlock(%s) %s'%(lockMe,item))

def lockNodeHierarchy(lockMe=1):
    originalSelection = pm.ls(sl=1)
    if not originalSelection: return
    pm.select(hi=1)
    lockNodes(lockMe)
    pm.select(originalSelection)