import pymel.all as pm
from pymel.internal.plogging import pymelLogger

grabbyFunction = '''import pymel.all as pm
from pymel.internal.plogging import pymelLogger

def Grabby():
    currentSelection = pm.ls(sl=1,l=1)
    if not currentSelection: return
    myObj = currentSelection.pop()
    if not pm.objExists(myObj+".DoGrabbyGrab"): return
    
    #grab the appropriate cap controls
    selection = []
    for grabeeAttr in pm.listAttr(myObj,st='GrabbyGrabee*'):
        inConnects = pm.listConnections('%s.%s'%(myObj, grabeeAttr),d=0,s=1)
        if not inConnects:
            pymelLogger.debug('%s missing grabee obj')
            continue
        selection.append(inConnects[0])
    pymelLogger.debug('%s will now select: %s'%(myObj,selection))
    
    if selection: #ignore empty grab sets
        pm.select(myObj,d=1) #deselect the trigger
        pm.select(selection,tgl=1) #toggle the new objects'''
grabbyJobContent="e=('SelectionChanged', 'Grabby()')"
grabbyJob = '\n\ncmds.scriptJob('+grabbyJobContent+')'

#the function to be stored in the script job
def Grabby():
    currentSelection = pm.ls(sl=1,l=1)
    if not currentSelection: return
    myObj = currentSelection.pop()
    if not pm.objExists(myObj+".DoGrabbyGrab"): return
    
    
    #grab the appropriate cap controls
    selection = []
    for grabeeAttr in pm.listAttr(myObj,st='GrabbyGrabee*'):
        inConnects = pm.listConnections('%s.%s'%(myObj, grabeeAttr),d=0,s=1)
        if not inConnects:
            pymelLogger.debug('%s missing grabee obj')
            continue
        selection.append(inConnects[0])
    pymelLogger.debug('%s will now select: %s'%(myObj,selection))
    
    if selection: #ignore empty grab sets
        pm.select(myObj,d=1) #deselect the trigger
        pm.select(selection,tgl=1) #toggle the new objects

#check for duplicate script nodes
def grabbyScriptNode():
    isFound = 0
    for myNode in pm.ls(type='script'):
        if pm.objExists('%s.jhGrabby'%myNode):
            if isFound:
                pm.delete(myNode)
                pymelLogger.debug('Deleted duplicate Grabby.')
            else:
                isFound = str(myNode)
    return isFound

def createGrabbyScriptNode():
    pymelLogger.debug('Creating brand new Grabby.')
    #create the script node with identifiers
    myScriptNode = pm.scriptNode(n='jhGrabby', st=1, stp='python', bs=grabbyFunction+grabbyJob)
    pm.addAttr(myScriptNode, ln='jhGrabby', at='short', min=0, max=1, dv=1, h=1) #identifies it as belonging to me
    pm.addAttr(myScriptNode, ln='myGrabbers', m=1, at='message') #brain connections to all grabbers in the scene
    #activate Grabby immediately
    pm.scriptNode('jhGrabby', eb=1)
    return myScriptNode

def grabbyScriptJob():
    import re
    isFound = 0
    myScriptJob = False
    startNumber = re.compile('^[0-9]+')
    for myJob in pm.scriptJob(lj=1):
        if grabbyJobContent in '%s'%myJob:
            #get the job number from the string
            jobNum = int(startNumber.search(str(myJob)).group())
            if isFound:
                pm.scriptJob(k=jobNum)
                pymelLogger.debug('Deleted duplicate script job.')
                continue
            pymelLogger.debug('Found script node: %s'%myJob)
            isFound = 1
            myScriptJob = jobNum
    return myScriptJob
    
def toggleGrabby():
    #check for the script node
    myScriptNode = grabbyScriptNode()
    if not myScriptNode:
        myScriptNode = createGrabbyScriptNode()
    #check the script jobs
    myScriptJob = grabbyScriptJob()
    if myScriptJob:
        pm.scriptJob(k=myScriptJob)
        pymelLogger.info('Grabby is now OFF')
    else:
        myScriptJob = pm.scriptJob(e=('SelectionChanged', 'Grabby()'))
        pymelLogger.info('Grabby is now ON')

def createGrabby():
    currSelection = pm.ls(sl=1) #get selection to act on
    if (not currSelection) or (len(currSelection)<2): #must have 2 or more objects
        pymelLogger.error('Please select 2 or more objects.')
        return
    controlObject = currSelection.pop() #grab the control object
    
    #check for the script node, we need it!
    myScriptNode = grabbyScriptNode()
    if not myScriptNode:
        myScriptNode = createGrabbyScriptNode()
    
    #check for grabby loop non-recursively
    badGrabs = []
    for myConnection in pm.listConnections('%s.message'%controlObject, p=1):
        myConnection = str(myConnection).split('.')
        if 'GrabbyGrabee' in myConnection[1]:
            for grabee in currSelection:
                if str(grabee) == myConnection[0]:
                    currSelection.remove(grabee)
                    badGrabs.append(grabee)
    if not (currSelection):
        pymelLogger.error('Recursive grabbing is a bad idea! No non-recursive objects remaining.')
        return
    
    #selection change only triggers on mouse click
    #therefore grabby runs only once THANK GOD loops won't infinitely run on their own!
    #just general confusion accounted for in above
    if not pm.objExists('%s.DoGrabbyGrab'%controlObject):
        pm.addAttr(controlObject, ln='DoGrabbyGrab', k=0, h=1, min=1, max=1)
        #pm.addAttr(controlObject, ln='DoGrabbyGrab', k=1, min=1, max=1)
    
    #register this object with the script node as a grabber
    if not controlObject in pm.listConnections('%s.myGrabbers'%myScriptNode):
        i=0
        while(pm.connectionInfo('%s.myGrabbers[%s]'%(myScriptNode,i),id=1)):
            i+=1
        pm.connectAttr('%s.message'%controlObject, '%s.myGrabbers[%s]'%(myScriptNode,i))
    #how many grabees already exist?
    numGrabees = len(pm.listAttr(controlObject,st='GrabbyGrabee*'))
    #add all of the grabees to the selection list
    for grabee in currSelection:
        numGrabees+=1
        pm.addAttr(controlObject, ln='GrabbyGrabee%s'%numGrabees, at='message')
        pm.connectAttr('%s.message'%grabee, '%s.GrabbyGrabee%s'%(controlObject,numGrabees))
    
    
    if badGrabs:
        print 'Recursive grabbing is a bad idea!  Removed recursive objects:'
        print badGrabs
        pymelLogger.warning('Added Grabby to %s.  Recursion found: some objects were removed.  See script editor for details.'%controlObject)
    else: pymelLogger.info('Added Grabby to %s.'%controlObject)
    
def deleteGrabby():
    currSelection = pm.ls(sl=1) #get selection to act on
    
    #with no selection, delete all grabby from the scene
    if not currSelection:
        myScriptNode = grabbyScriptNode()
        if not myScriptNode: return #nothing to do here
        currSelection = pm.listConnections('%s.myGrabbers'%myScriptNode) #get all grabber objects as a fake selection
        pm.delete(myScriptNode) #delete the script Node
        pymelLogger.info('Grabby stripped from scene file.')
    else:
        pymelLogger.info('No longer Grabby: %s'%currSelection)
    
    #strip the grabber objects of their grabbiness
    for myObject in currSelection:
        for myAttr in pm.listAttr(myObject, st=['DoGrabbyGrab','GrabbyGrabee*']):
            pm.deleteAttr('%s.%s'%(myObject,myAttr))