import pymel.all as pm
from pymel.internal.plogging import pymelLogger

#mass attribute connection
def massConnect(source='', target=''):
	myList=pm.ls(sl=1)
	if not (myList):
		pymelLogger.error('No objects selected.')
		return
	myControl = myList.pop()
	if not (myList):
		pymelLogger.error('Must select more than one object')
		return
	
	if not source:
		result1 = pm.promptDialog(title='Attribute Selector', message='Enter source attribute:', button=['OK', 'Cancel'], defaultButton='OK', cancelButton='Cancel', dismissString='Cancel')
		if result1 == "OK":
			source = pm.promptDialog(query=True, text=True)
		else: return
	if not target:
		result2 = pm.promptDialog(title='Attribute Selector', message='Enter target attribute:', button=['OK', 'Cancel'], defaultButton='OK', cancelButton='Cancel', dismissString='Cancel')
		if result2 == "OK":
			target = pm.promptDialog(query=True, text=True)
		else: return
	if not pm.objExists('%s.%s'%(myControl,source)):
		pymelLogger.error('%s does not have attribute "%s"'%(myControl,source))
		return
	
	failedConnections=[]
	for myItem in myList:
		try: pm.connectAttr('%s.%s'%(myControl,source), '%s.%s'%(myItem,target), f=1)
		except: failedConnections.append(myItem)
	if failedConnections:
		print failedConnections
		pymelLogger.error('%s object%s not have attribute "%s" or have have incompatible attribute types'%(len(failedConnections),' does' if (len(failedConnections)==1) else 's do',target))